package gov.va.med.domain.service.messaging.environment;

import java.util.ArrayList;
import java.util.List;

/**
 * Temporary solution to isolate the logic to determine if a site 
 * has implemented the MHV package that supprots a gievn the function.
 * <P>
 * FUTURE This will be configurable in the future, probably in the Functions table with
 * required Package level. But this couples the messaging framework with this concept 
 * and is a sub-optimal approach. 
 * Further complication:  the patches installed.   Need a way to know what patches a site
 * has installed and what this mean in terms of what is supported. 
 *   
 * @author Joel Goldberg
 * @version $Id: VersionInterpreter.java,v 1.3 2005/07/26 20:22:20 joel.goldberg Exp $
 * @since MHV 2.0 <br>Jul 19, 2005
 */
public class VersionInterpreter {

	private static List phrFunctions = createPhrFunctions();
	private static List rxRefillFunctions = createRxRefillFunctions();
	
	public static boolean isFunctionSupportedByVersion(String functionName, 
				 									 String majorVersion, 
				 									 String minorVersion) {
	    //FUTURE make this configurable to elminate hard code. 
	    if (isPhrFunction(functionName)) { 
	        return versionSupportsPhr(majorVersion, minorVersion);
	    }
	    if (isRxRefillFunction(functionName)) { 
	        return versionSupportsRxRefill(majorVersion, minorVersion);
	    }
	    // most likely MPI but could be Application Ack.  In any case, 
	    // it is not constrained by the MHV Package at the site. We are good to go.  
	    return true;  
	}
	    
	public static boolean versionSupportsPhr(String majorVersion, 
				 					  String minorVersion){
	    try {
	        return Integer.parseInt(majorVersion) >= 2;
	    }
	    catch (Exception e) {
	    	return false;
	    }
	}
	
	public static boolean versionSupportsRxRefill(String majorVersion, 
			  							   String minorVersion){
		try {
		    return Integer.parseInt(majorVersion) >= 1;
		}
		catch (Exception e) {
		    return false;
		}
	}

	private static boolean isRxRefillFunction(String functionName) {
	    return getRxRefillFunctions().contains(functionName);
	}
	
	private static boolean isPhrFunction(String functionName) {
	    return getPhrFunctions().contains(functionName);
	}
	
	private static List createPhrFunctions() {
		List functions = new ArrayList();
		functions.add("getAppointments");
		functions.add("getProblemList");
		functions.add("getVitalSigns");
		functions.add("getCopays");
		functions.add("getAllergies");
		functions.add("getECG");
		functions.add("getAdmissionsAndDischarges");
		functions.add("getPersonalInformation");
		functions.add("getImmunizations");
		functions.add("getPathologyLabs");
		functions.add("getChemistryLabs");
		functions.add("getMicroscopyLabs");
		functions.add("getCytologyLabs");
		functions.add("getRadiologies");
		functions.add("getReminders");
		functions.add("getProgressNotes");
		functions.add("getMicrobiologyLabs");
		return functions; 
	}
	private static List createRxRefillFunctions() {
	    List functions = new ArrayList();
		functions.add("refillPrescription");
		functions.add("getPrescriptionStatus");
		functions.add("getPrescriptionProfile");
		functions.add("getPrescriptionUpdate"); 
		return functions; 
	}

    public static List getPhrFunctions() {
        return phrFunctions;
    }
    public static List getRxRefillFunctions() {
        return rxRefillFunctions;
    }
}
